DROP TABLE IF EXISTS plugins;
DROP TABLE IF EXISTS social_providers;
DROP TABLE IF EXISTS api_providers;

ALTER TABLE users DROP COLUMN name;
ALTER TABLE admins DROP COLUMN name;

ALTER TABLE users 
ADD COLUMN facebook_id VARCHAR(255) UNIQUE NULL AFTER password,
ADD COLUMN google_id VARCHAR(255) UNIQUE NULL AFTER facebook_id,
ADD COLUMN microsoft_id VARCHAR(255) UNIQUE NULL AFTER google_id,
ADD COLUMN vkontakte_id VARCHAR(255) UNIQUE NULL AFTER microsoft_id;

ALTER TABLE users 
MODIFY COLUMN firstname VARCHAR(255) NULL,
MODIFY COLUMN lastname VARCHAR(255) NULL,
MODIFY COLUMN email VARCHAR(255) NULL,
MODIFY COLUMN password VARCHAR(255) NULL;


ALTER TABLE admins 
ADD COLUMN google2fa_status BOOLEAN DEFAULT false COMMENT '0: Disabled, 1: Active' AFTER password,
ADD COLUMN google2fa_secret TEXT NULL AFTER google2fa_status;


DELETE FROM `extensions` WHERE `alias`= "google_recaptcha";
DELETE FROM `extensions` WHERE `alias`= "facebook_oauth";


INSERT INTO `settings` (`key`, `value`) VALUES ('cronjob', '{\"key\":\"\",\"last_execution\":\"\"}');

INSERT INTO `settings` (`key`, `value`) VALUES ('maintenance', '{\"status\":0,\"title\":\"Under Maintenance\",\"body\":\"<p style=\\\"text-align:center;\\\">Our site is currently undergoing scheduled maintenance to enhance your browsing experience. We apologize for any inconvenience and appreciate your patience. Please check back soon!<\\/p>\"}');


ALTER TABLE plans DROP COLUMN sizes;
ALTER TABLE plans ADD COLUMN engines LONGTEXT NULL AFTER max_images;


CREATE TABLE `engines` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handler` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `credentials` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `instructions` longtext COLLATE utf8mb4_unicode_ci,
  `filters` longtext COLLATE utf8mb4_unicode_ci,
  `support_negative_prompt` tinyint(1) NOT NULL DEFAULT '0',
  `sizes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `art_styles` longtext COLLATE utf8mb4_unicode_ci,
  `lightning_styles` longtext COLLATE utf8mb4_unicode_ci,
  `moods` longtext COLLATE utf8mb4_unicode_ci,
  `max` int NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `engines` (`id`, `name`, `alias`, `logo`, `handler`, `credentials`, `instructions`, `filters`, `support_negative_prompt`, `sizes`, `art_styles`, `lightning_styles`, `moods`, `max`, `status`, `created_at`, `updated_at`) VALUES
(1, 'DALLE 2', 'dall-e-2', 'images/engines/openai-dalle-2.png', 'App\\Engines\\OpenAIDalle2Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.openai.com/api-keys\" target=\"_blank\">https://platform.openai.com/api-keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>256x256</li>\n    <li>512x512</li>\n    <li>1024x1024</li>\n</ul>', 'porn,sex,sexy', 0, '256x256,512x512,1024x1024', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 10, 0, '2024-03-23 17:21:38', '2024-11-04 11:04:36'),
(2, 'DALLE 3', 'dall-e-3', 'images/engines/openai-dalle-3.png', 'App\\Engines\\OpenAIDalle3Engine', '{\"api_key\":null}', '<p>\r\n    You can get your API key from: <a href=\"https://platform.openai.com/api-keys\" target=\"_blank\">https://platform.openai.com/api-keys</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1024x1024</li>\r\n    <li>1792x1024</li>\r\n    <li>1024x1792</li>\r\n</ul>', 'porn,sex,sexy', 0, '1024x1024,1792x1024,1024x1792', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:24:17', '2024-11-04 11:04:41'),
(3, 'FLUX Dev', 'flux-dev', 'images/engines/replicate.png', 'App\\Engines\\ReplicateFluxEngine', '{\"api_token\":null}', '<p>\r\n    You can get your API token from: <a href=\"https://replicate.com/account/api-tokens\" target=\"_blank\">https://replicate.com/account/api-tokens</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1:1</li>\r\n    <li>2:3</li>\r\n    <li>3:2</li>\r\n    <li>4:5</li>\r\n    <li>5:4</li>\r\n    <li>4:3</li>\r\n    <li>3:4</li>\r\n    <li>16:9</li>\r\n    <li>21:9</li>\r\n    <li>9:16</li>\r\n    <li>9:21</li>\r\n</ul>\r\n\r\n', 'porn,sex,sexy', 0, '1:1,2:3,3:2,4:5,5:4,4:3,3:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 4, 0, '2024-03-23 17:35:53', '2024-11-04 11:04:48'),
(4, 'FLUX Pro', 'flux-pro', 'images/engines/replicate.png', 'App\\Engines\\ReplicateFluxEngine', '{\"api_token\":null}', '<p>\r\n    You can get your API token from: <a href=\"https://replicate.com/account/api-tokens\" target=\"_blank\">https://replicate.com/account/api-tokens</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1:1</li>\r\n    <li>2:3</li>\r\n    <li>3:2</li>\r\n    <li>4:5</li>\r\n    <li>5:4</li>\r\n    <li>4:3</li>\r\n    <li>3:4</li>\r\n    <li>16:9</li>\r\n    <li>21:9</li>\r\n    <li>9:16</li>\r\n    <li>9:21</li>\r\n</ul>\r\n\r\n', 'porn,sex,sexy', 0, '1:1,2:3,3:2,4:5,5:4,4:3,3:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:35:53', '2024-11-04 11:04:54'),
(5, 'FLUX 1.1 Pro', 'flux-1.1-pro', 'images/engines/replicate.png', 'App\\Engines\\ReplicateFluxEngine', '{\"api_token\":null}', '<p>\r\n    You can get your API token from: <a href=\"https://replicate.com/account/api-tokens\" target=\"_blank\">https://replicate.com/account/api-tokens</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1:1</li>\r\n    <li>2:3</li>\r\n    <li>3:2</li>\r\n    <li>4:5</li>\r\n    <li>5:4</li>\r\n    <li>4:3</li>\r\n    <li>3:4</li>\r\n    <li>16:9</li>\r\n    <li>21:9</li>\r\n    <li>9:16</li>\r\n    <li>9:21</li>\r\n</ul>\r\n\r\n', 'porn,sex,sexy', 0, '1:1,2:3,3:2,4:5,5:4,4:3,3:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:35:53', '2024-11-04 11:04:59'),
(6, 'FLUX Schnell', 'flux-schnell', 'images/engines/replicate.png', 'App\\Engines\\ReplicateFluxEngine', '{\"api_token\":null}', '<p>\r\n    You can get your API token from: <a href=\"https://replicate.com/account/api-tokens\" target=\"_blank\">https://replicate.com/account/api-tokens</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1:1</li>\r\n    <li>2:3</li>\r\n    <li>3:2</li>\r\n    <li>4:5</li>\r\n    <li>5:4</li>\r\n    <li>4:3</li>\r\n    <li>3:4</li>\r\n    <li>16:9</li>\r\n    <li>21:9</li>\r\n    <li>9:16</li>\r\n    <li>9:21</li>\r\n</ul>\r\n\r\n', 'porn,sex,sexy', 0, '1:1,2:3,3:2,4:5,5:4,4:3,3:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 4, 0, '2024-03-23 17:35:53', '2024-11-04 11:05:05'),
(7, 'Stable Diffusion Xl v1.0', 'stable-diffusion-xl-1024-v1-0', 'images/engines/stability-ai.png', 'App\\Engines\\StabilityAiEngine', '{\"api_key\":null}', '<p>\r\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\r\n</p>\r\n<p>\r\n    <strong>Allowed Sizes</strong>\r\n</p>\r\n<ul>\r\n    <li>1024x1024</li>\r\n    <li>1152x896</li>\r\n    <li>896x1152</li>\r\n    <li>1216x832</li>\r\n    <li>1344x768</li>\r\n    <li>768x1344</li>\r\n    <li>1536x640</li>\r\n    <li>640x1536</li>\r\n</ul>', 'porn,sex,sexy', 1, '1024x1024,1152x896,896x1152,1216x832,1344x768,768x1344,1536x640,640x1536', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 10, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:12'),
(8, 'Stable Diffusion v1.6', 'stable-diffusion-v1-6', 'images/engines/stability-ai.png', 'App\\Engines\\StabilityAiEngine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1024x1024</li>\n    <li>1152x896</li>\n    <li>896x1152</li>\n    <li>1216x832</li>\n    <li>1344x768</li>\n    <li>768x1344</li>\n    <li>1536x640</li>\n    <li>640x1536</li>\n</ul>', 'porn,sex,sexy', 1, '1024x1024,1152x896,896x1152,1216x832,1344x768,768x1344,1536x640,640x1536', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 10, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:17'),
(9, 'Stable Diffusion Image Ultra', 'stable-image-ultra', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageUltraEngine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:23'),
(10, 'Stable Diffusion Image Core', 'stable-image-core', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageCoreEngine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:29'),
(11, 'Stable Diffusion 3 Medium', 'sd3-medium', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:35'),
(12, 'Stable Diffusion 3 Large', 'sd3-large', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:40'),
(13, 'Stable Diffusion 3 Large Turbo', 'sd3-large-turbo', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:46'),
(14, 'Stable Diffusion 3.0 Medium', 'sd3.5-medium', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:51'),
(15, 'Stable Diffusion 3.5 Large', 'sd3.5-large', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:05:57'),
(16, 'Stable Diffusion 3.5 Large Turbo', 'sd3.5-large-turbo', 'images/engines/stability-ai.png', 'App\\Engines\\StableImageSD3Engine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://platform.stability.ai/account/keys\" target=\"_blank\">https://platform.stability.ai/account/keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>1:1</li>\n    <li>2:3</li>\n    <li>3:2</li>\n    <li>4:5</li>\n    <li>5:4</li>\n    <li>16:9</li>\n    <li>21:9</li>\n    <li>9:16</li>\n    <li>9:21</li>\n</ul>\n', 'porn,sex,sexy', 1, '1:1,2:3,3:2,4:5,5:4,16:9,21:9,9:16,9:21', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 1, 0, '2024-03-23 17:28:35', '2024-11-04 11:06:02'),
(17, 'Modelslab Stable Diffusion', 'stable-diffusion-api', 'images/engines/stable-diffusion-api.png', 'App\\Engines\\ModelsLabSDEngine', '{\"api_key\":null}', '<p>\n    You can get your API key from: <a href=\"https://modelslab.com/dashboard/api-keys\" target=\"_blank\">https://modelslab.com/dashboard/api-keys</a>\n</p>\n<p>\n    <strong>Allowed Sizes</strong>\n</p>\n<ul>\n    <li>512x512</li>\n    <li>1024x1024</li>\n    <li>1920x1080</li>\n    <li>1800x1200</li>\n    <li>1200x1800</li>\n    <li>1080x1350</li>\n    <li>1280x1024</li>\n    <li>1080x1440</li>\n    <li>1024x768</li>\n    <li>1080x1920</li>\n    <li>1080x2560</li>\n</ul>', 'porn,sex,sexy', 1, '512x512,1024x1024,1920x1080,2560x1080,1800x1200,1200x1800,1080x1350,1280x1024,1080x1440,1024x768,1080x1920,1080x2560', '3d model, Analog film, Anime, Cinematic, Comic book, Digital art, Enhance, Fantasy art, Isometric, Line art, Low poly, Modeling compound, Neon punk, Origami, Photographic, Pixel art, Tile texture', 'Ambient, Backlight, Blue Hour, Cinematic, Cold, Dramatic, Foggy, Golden Hour, Hard, Natural, Neon, Studio, Warm', 'Aggressive, Angry, Boring, Bright, Calm, Cheerful, Chilling, Colorful, Dark, Neutral', 4, 0, '2024-03-23 17:35:53', '2024-11-04 11:06:08');


ALTER TABLE `engines` ADD PRIMARY KEY (`id`);

ALTER TABLE `engines` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;


ALTER TABLE generated_images 
ADD COLUMN engine_id BIGINT UNSIGNED NULL AFTER storage_provider_id,
ADD CONSTRAINT generated_images_engine_id_foreign FOREIGN KEY (engine_id) REFERENCES engines(id) ON DELETE CASCADE,
ADD COLUMN art_style VARCHAR(255) NULL AFTER size,
ADD COLUMN lightning_style VARCHAR(255) NULL AFTER art_style,
ADD COLUMN mood VARCHAR(255) NULL AFTER lightning_style;




